hpSetGet = {};

function hpSetGet:generateDisplay()
	if g_currentMission.hud ~= nil and g_currentMission.hud.infoDisplay ~= nil then
		HeapPreview.values.display = g_currentMission.hud.infoDisplay:createBox(InfoDisplayKeyValueBox);
		HeapPreview.values.display:setTitle(tostring(HeapPreview.metadata.title));
	end;
end;

function hpSetGet:showInfoBoxOrText(state)
	if not state then hpSetGet:clearInfoBox(HeapPreview.values.display);return;end;
	if HeapPreview.values.display ~= nil and HeapPreview.values.viewIngameBox then
		hpSetGet:showInfoBox(HeapPreview.values.display)
	else
		hpSetGet:showInfoText()
	end;
end;

function hpSetGet:showInfoBox(box)
	hpSetGet:clearInfoBox(box);				
	box:addLine(g_i18n:getText("statistic_fillType"), "Radius ".. tostring(HeapPreview.values.radius));
	box:addLine(tostring(HeapPreview.values.fillTypeName), tostring(g_i18n:formatVolume(HeapPreview.values.fillLevel)));
	box:showNextFrame();	
end;

function hpSetGet:clearInfoBox(box)
	box:clear();
end;

function hpSetGet:showInfoText()
	if not HeapPreview.values.viewFillLevel then
		g_currentMission:addExtraPrintText(g_i18n:getText("statistic_fillType").. ": ".. tostring(HeapPreview.values.fillTypeName));
	else
		g_currentMission:addExtraPrintText(g_i18n:getText("statistic_fillType").. ": ".. tostring(HeapPreview.values.fillTypeName).. " | ".. tostring(g_i18n:formatVolume(HeapPreview.values.fillLevel)));		
	end;
end;

function hpSetGet:setHeapValues(delete, fillType, fillTypeName, fillLevel, x, y, z, widthX, widthZ, heightX, heightZ, pX, pY, pZ)
	--if args == nil or type(args) ~= "table" then return;end; --later new
	if delete then
		HeapPreview.values.foundHeap = false;
		HeapPreview.values.fillType = 0;
		HeapPreview.values.fillLevel = 0;
		HeapPreview.values.fillTypeName = "";
		HeapPreview.values.hx = 0;
		HeapPreview.values.hy = 0;
		HeapPreview.values.hz = 0;
		HeapPreview.values.px = 0;
		HeapPreview.values.py = 0;
		HeapPreview.values.pz = 0;
		HeapPreview.values.widthX = 0;
		HeapPreview.values.widthZ = 0;
		HeapPreview.values.heightX = 0;
		HeapPreview.values.heightZ = 0;
	else
		HeapPreview.values.fillType = fillType;
		HeapPreview.values.fillTypeName = fillTypeName;
		HeapPreview.values.fillLevel = fillLevel;
		HeapPreview.values.hx = x;
		HeapPreview.values.hy = y;
		HeapPreview.values.hz = z;
		HeapPreview.values.px = pX;
		HeapPreview.values.py = pY;
		HeapPreview.values.pz = pZ;
		HeapPreview.values.widthX = widthX;
		HeapPreview.values.widthZ = widthZ;
		HeapPreview.values.heightX = heightX;
		HeapPreview.values.heightZ = heightZ;
		HeapPreview.values.foundHeap = true;		
	end;
end;

function hpSetGet:getFillTypeName(fillType)
	local name = "Unknown";
	local desc = g_fillTypeManager:getFillTypeByIndex(fillType);
	if desc ~= nil then 
		name = desc.title;
	end;
	return name;
end;

function hpSetGet:getIsOnField(x,y,z) 
	if x == nil or y == nil or z == nil then return true;end;
	local isOnField, _ = FSDensityMapUtil.getFieldDataAtWorldPosition(x, y, z); 
    return isOnField;
end;

function hpSetGet:isHeapDraw()	
	local x, y, z;
	local rootNode = HeapPreview:getPlayerData(true);
	if rootNode == nil then return nil,nil,nil,nil;end; --MP Join Event
	local onVehicle = HeapPreview:getPlayerData();	
	
	if not onVehicle then x, y, z = getWorldTranslation(rootNode);end;
	if not onVehicle and not HeapPreview.values.onField and hpSetGet:getIsOnField(x,y,z) then return nil, nil, nil, nil;end;
	if not onVehicle and HeapPreview.values.onFoot then return x, y, z, rootNode;end;
	
	return nil, nil, nil, nil;
end;

function hpSetGet:searchHeaps()
	local x, y, z, rootNode = hpSetGet:isHeapDraw();		
	if x ~= nil and y ~= nil and z ~= nil and rootNode ~= nil then		
		local radius = HeapPreview.values.radius;		
		local x0,y0,z0 = localToWorld(rootNode, x + radius, y, z - radius);
        local x1,y1,z1 = localToWorld(rootNode, x - radius, y, z - radius);
        local x2,y2,z2 = localToWorld(rootNode, x + radius, y, z + radius);
		local x3,y3,z3 = localToWorld(rootNode, x - radius, y, z + radius); 
		local hx, hz, widthX, widthZ, heightX, heightZ = MathUtil.getXZWidthAndHeight(x0,z0, x1,z1, x2,z2);
		local xS1, zS1, widthX1, widthZ1, heightX1, heightZ1 = MathUtil.getXZWidthAndHeight(x2,z2, x1,z1, x0,z0); 
		local height = HeapPreview.values.height; 

		local fillType = DensityMapHeightUtil.getFillTypeAtLine(x, y, z, x, y, z, radius);
		local fillLevel = nil;		
		if fillType ~= nil and fillType ~= 0 then
			local descName = g_fillTypeManager:getFillTypeByIndex(fillType);
			if descName.name ~= "TARP" and descName.name ~= "AIR" then 
				fillLevel = DensityMapHeightUtil.getFillLevelAtArea(fillType, hx, hz, widthX, widthZ, heightX, heightZ);	
			end
		end;
		if fillLevel ~= nil and fillLevel ~= 0 then			
			hpSetGet:setHeapValues(false, fillType, hpSetGet:getFillTypeName(fillType), fillLevel, hx, y, hz, widthX, widthZ, heightX, heightZ, x, y, z);			
		else
			hpSetGet:setHeapValues(true);
		end;
	else
		hpSetGet:setHeapValues(true);
	end;
end;

function hpSetGet:getMapState(isPaused ,isOpen)	
	function mapState()
		return Utils.getNoNil(g_gameSettings:getValue("ingameMapState"), 0) == 4;
	end;
	function totalState(isPaused ,isOpen)	
		if (g_currentMission.paused and isPaused) or
			(g_gui:getIsGuiVisible() and isOpen) or 
			(g_currentMission.hud.ingameMessage.isGamePaused and isPaused) or 
			--(g_currentMission.inGameMenu.isOpen and isOpen) or		
			(g_currentMission.physicsPaused and isPaused) or
			(not g_currentMission.hud.isVisible) or 
			(g_currentMission.noHudApp ~= nil and g_currentMission.noHudApp) then 
			if g_currentMission.missionDynamicInfo.isMultiplayer and g_currentMission.manualPaused and isPaused and g_gameStateManager.gameState ~= 5 then return false;end;
			return true;
		end;
		return false;
	end;
	return mapState() and totalState();
end;