-- Copyright 2024-2025 by Todd Hundersmarck (ThundR) 
-- All Rights Reserved

local thMain = g_thBetterWinch
THVSpec_WinchObject = {}
local debugFlagId = THDebugUtil.createFlagId("THVSpec_WinchObject", true)
THVSpec_WinchObject.debugFlagId = debugFlagId
THVSpec_WinchObject.MOD_NAME = thMain.modName
THVSpec_WinchObject.SPEC_NAME = thMain.dataKey .. "Object"
THVSpec_WinchObject.SPEC_TABLE_KEY = "spec_" .. THVSpec_WinchObject.MOD_NAME .. "." .. THVSpec_WinchObject.SPEC_NAME
THVSpecData_WinchObject = {}
function THVSpec_WinchObject.prerequisitesPresent(specializations)
    return true
end
function THVSpec_WinchObject.registerEventListeners(vehicleType)
    SpecializationUtil.registerEventListener(vehicleType, "onLoad", THVSpec_WinchObject)
    SpecializationUtil.registerEventListener(vehicleType, "onPostLoad", THVSpec_WinchObject)
    SpecializationUtil.registerEventListener(vehicleType, "onPostDetach", THVSpec_WinchObject)
    SpecializationUtil.registerEventListener(vehicleType, "onLeaveVehicle", THVSpec_WinchObject)
end
function THVSpec_WinchObject.registerOverwrittenFunctions(vehicleType)
end
function THVSpec_WinchObject.getSpecTable(vehicle)
    if vehicle ~= nil then
        return vehicle[THVSpec_WinchObject.SPEC_TABLE_KEY]
    end
end
local getSpecTable = THVSpec_WinchObject.getSpecTable
function THVSpec_WinchObject.onLoad(self, savegame)
    THUtils.call(function()
        local specTable = getSpecTable(self)
        if specTable ~= nil then
            specTable.vehicle = self
            specTable.attachPoints = {}
            specTable.attachPointMapping = {}
            THUtils.copyFunctions(specTable, THVSpecData_WinchObject)
            for componentIndex = 1, #self.components do
                local componentInfo = self.components[componentIndex]
                specTable:loadAttachPoints(componentInfo.node)
            end
        end
    end)
end
function THVSpec_WinchObject.onPostLoad(self, savegame)
    THUtils.call(function()
        local specTable = getSpecTable(self)
        if specTable ~= nil then
            local vehicleName = self:getName()
            local attachableSpec = self.spec_attachable
            local attacherJointSpec = self.spec_attacherJoints
            local isDebugEnabled = THDebugUtil.getIsEnabled(debugFlagId)
            local numAttachPoints = #specTable.attachPoints
            if numAttachPoints > 0 then
                for attachPointIndex = 1, numAttachPoints do
                    local attachNode = specTable.attachPoints[attachPointIndex]
                    local attachPointData = thMain:addObjectAttachPoint(self, attachNode)
                    if attachPointData ~= nil then
                        if isDebugEnabled then
                            THUtils.displayMsg("%s: Added attachment point:", vehicleName)
                            THDebugUtil.printTable(attachPointData)
                        end
                    end
                end
            end
            if attachableSpec ~= nil then
                if self.getInputAttacherJoints ~= nil then
                    local inputAttacherJoints = self:getInputAttacherJoints()
                    if inputAttacherJoints ~= nil then
                        for jointIndex = 1, #inputAttacherJoints do
                            local jointInfo = inputAttacherJoints[jointIndex]
                            if jointInfo.jointType == AttacherJoints.JOINTTYPE_TRAILER
                                or jointInfo.jointType == AttacherJoints.JOINTTYPE_TRAILERLOW
                                or jointInfo.jointType == AttacherJoints.JOINTTYPE_TRAILERCAR
                            then
                                if type(jointInfo.node) == THValueType.NUMBER
                                    and jointInfo.node > 0
                                    and entityExists(jointInfo.node)
                                then
                                    local attachPointData = thMain:injectObjectAttachPoint(self, jointInfo.node, 0, 0, 0, 0, 0, 0)
                                    if attachPointData ~= nil then
                                        if isDebugEnabled then
                                            THUtils.displayMsg("%s: Added attachment point to node: %s", vehicleName, getName(jointInfo.node))
                                            THDebugUtil.printTable(attachPointData)
                                        end
                                    end
                                end
                            end
                        end
                    end
                end
            end
            if attacherJointSpec ~= nil then
                if self.getAttacherJoints ~= nil then
                    local attacherJoints = self:getAttacherJoints()
                    if attacherJoints ~= nil then
                        for jointIndex = 1, #attacherJoints do
                            local jointInfo = attacherJoints[jointIndex]
                            if jointInfo.jointType == AttacherJoints.JOINTTYPE_TRAILER
                                or jointInfo.jointType == AttacherJoints.JOINTTYPE_TRAILERLOW
                                or jointInfo.jointType == AttacherJoints.JOINTTYPE_TRAILERCAR
                            then
                                if type(jointInfo.jointTransform) == THValueType.NUMBER
                                    and jointInfo.jointTransform > 0
                                    and entityExists(jointInfo.jointTransform)
                                then
                                    local attachPointData = thMain:injectObjectAttachPoint(self, jointInfo.jointTransform, 0, 0, 0, 0, 0, 0)
                                    if attachPointData ~= nil then
                                        if isDebugEnabled then
                                            THUtils.displayMsg("%s: Added attachment point to node: %s", vehicleName, getName(jointInfo.jointTransform))
                                            THDebugUtil.printTable(attachPointData)
                                        end
                                    end
                                end
                            end
                        end
                    end
                end
            end
        end
    end)
end
function THVSpec_WinchObject.onPostDetach(self)
    local specTable = getSpecTable(self)
    THUtils.call(function()
        if specTable ~= nil then
            specTable:setObjectAttachNodesDirty()
        end
    end)
end
function THVSpec_WinchObject.onLeaveVehicle(self)
    local specTable = getSpecTable(self)
    THUtils.call(function()
        if specTable ~= nil then
            specTable:setObjectAttachNodesDirty()
        end
    end)
end
function THVSpecData_WinchObject.loadAttachPoints(specTable, nodeId)
    if type(nodeId) == THValueType.NUMBER and nodeId > 0
        and entityExists(nodeId)
    then
        if specTable.attachPointMapping[nodeId] == nil
            and getHasClassId(nodeId, ClassIds.SHAPE)
            and getHasCollision(nodeId)
            and getShapeIsCPUMesh(nodeId)
        then
            table.insert(specTable.attachPoints, nodeId)
            specTable.attachPointMapping[nodeId] = #specTable.attachPoints
        end
        local numChildren = getNumOfChildren(nodeId)
        if numChildren ~= nil and numChildren > 0 then
            for childIndex = 1, numChildren do
                local childNode = getChildAt(nodeId, childIndex - 1)
                specTable:loadAttachPoints(childNode)
            end
        end
    end
end
function THVSpecData_WinchObject.setObjectAttachNodesDirty(specTable)
    local self = specTable.vehicle
    local attachNodes = thMain:getObjectAttachNodes(self)
    if attachNodes ~= nil then
        for _, objectData in pairs(attachNodes) do
            objectData.isDirty = true
        end
    end
end