--[[
Copyright (C) GtX (Andy), 2019

Author: GtX | Andy
Date: 04.01.2019
Revision: FS25-01

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

Important:
Not to be added to any mods / maps or modified from its current release form.
No modifications may be made to this script, including conversion to other game versions without written permission from GtX | Andy
Copying or removing any part of this code for external use without written permission from GtX | Andy is prohibited.

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
Ohne schriftliche Genehmigung von GtX | Andy dürfen keine Änderungen an diesem Skript vorgenommen werden, einschließlich der Konvertierung in andere Spielversionen
Das Kopieren oder Entfernen irgendeines Teils dieses Codes zur externen Verwendung ohne schriftliche Genehmigung von GtX | Andy ist verboten.
]]


TransferOwnershipManager = {}
TransferOwnershipManager.DEBUG_ENABLED = false

local TransferOwnershipManager_mt = Class(TransferOwnershipManager)

local modName = g_currentModName
local modDirectory = g_currentModDirectory

local versionString = "0.0.0.0"
local buildId = 0

local validationFail

function TransferOwnershipManager.new()
    local self = setmetatable({}, TransferOwnershipManager_mt)

    self.isServer = g_server ~= nil
    self.isClient = g_client ~= nil

    self.versionString = versionString
    self.buildId = buildId

    self.modName = modName

    MessageType.TRANSFER_OWNERSHIP_UPDATE_OBJECTS = nextMessageTypeId()

    return self
end

function TransferOwnershipManager:load()
    g_overlayManager:addTextureConfigFile(modDirectory .. "hud/gui.xml", "transferOwnership")

    g_transferOwnershipScreen = TransferOwnershipScreen.register()

    g_messageCenter:subscribe(MessageType.TRANSFER_OWNERSHIP_UPDATE_OBJECTS, self.onUpdateObjects, self)

    return true
end

function TransferOwnershipManager:delete()
    g_messageCenter:unsubscribeAll(self)
    g_transferOwnershipManager = nil
end

function TransferOwnershipManager:onUpdateObjects(transferPoint)
    local mission = g_currentMission
    local shopController = g_shopController

    if mission ~= nil and shopController ~= nil then
        local farmId = mission:getFarmId()

        shopController:setOwnedFarmItems(mission.ownedItems, farmId)
        shopController:setLeasedFarmItems(mission.leasedItems, farmId)
    end
end

local function validateMod()
    local mod = g_modManager:getModByName(modName)

    if mod == nil or g_iconGenerator ~= nil or g_isEditor then
        return false
    end

    versionString = mod.version or versionString

    if mod.modName == "FS25_TransferOwnership" or mod.modName == "FS25_TransferOwnership_update" then
        if mod.author ~= nil and #mod.author == 3 then
            return true
        end
    end

    validationFail = {
        startUpdateTime = 2000,

        update = function(self, dt)
            self.startUpdateTime = self.startUpdateTime - dt

            if self.startUpdateTime < 0 then
                local text = string.format(g_i18n:getText("transferOwnership_loadError", mod.modName), mod.modName, mod.author or "Unknown")

                if g_dedicatedServer == nil then
                    if not g_gui:getIsGuiVisible() then
                        local title = string.format("%s - Version %s", mod.title, versionString)
                        local yesText = g_i18n:getText("button_modHubDownload")
                        local noText = g_i18n:getText("button_ok")

                        YesNoDialog.show(self.openModHubLink, nil, text, title, yesText, noText, DialogElement.TYPE_LOADING)
                    end
                else
                    print("\n" .. text .. "\n    - https://farming-simulator.com/mods.php?&title=fs2025&filter=org&org_id=129652&page=0" .. "\n")
                    self.openModHubLink(false)
                end
            end
        end,

        openModHubLink = function(yes)
            if yes then
                openWebFile("mods.php?title=fs2025&filter=org&org_id=129652&page=0", "")
            end

            removeModEventListener(validationFail)
            validationFail = nil
        end
    }

    addModEventListener(validationFail)

    return false
end

local function init()
    if validateMod() then
        source(modDirectory .. "scripts/events/TransferOwnershipEvent.lua")
        source(modDirectory .. "scripts/TransferOwnershipPoint.lua")
        source(modDirectory .. "scripts/gui/TransferOwnershipScreen.lua")

        local transferOwnershipManager = TransferOwnershipManager.new()

        -- Allow users to block Transfer Ownership triggers from being added to Workshops by adding and activating a simple mod named 'FS25_TransferOwnershipIgnoreWorkshops'.
        -- Mod only requires a modDesc.xml along with an icon as the mod is disabled by mod name only not the content...
        if not g_modIsLoaded["FS25_TransferOwnershipIgnoreWorkshops"] then
            local numInserted = 0

            TypeManager.validateTypes = Utils.prependedFunction(TypeManager.validateTypes, function (typeManager)
                if typeManager.typeName == "placeable" and numInserted == 0 then
                    local specializationName = string.format("%s.workshopTransferOwnershipPoint", modName)
                    local specializationObject = g_placeableSpecializationManager:getSpecializationObjectByName(specializationName)

                    if specializationObject ~= nil then
                        for typeName, typeEntry in pairs (typeManager:getTypes()) do
                            if specializationObject.prerequisitesPresent(typeEntry.specializations) then
                                typeManager:addSpecialization(typeName, specializationName)

                                numInserted += 1
                            end
                        end
                    end
                end
            end)
        else
            Logging.info("[TransferOwnershipManager] Found active mod with name 'FS22_TransferOwnershipIgnoreWorkshops' transfer ownership will not be added to placeable workshops.")
        end

        FSBaseMission.loadMapFinished = Utils.prependedFunction(FSBaseMission.loadMapFinished, function(currentMission)
            if transferOwnershipManager ~= nil and transferOwnershipManager:load() then
                currentMission:addNonUpdateable(transferOwnershipManager)
            end
        end)

        g_transferOwnershipManager = transferOwnershipManager
    else
        g_placeableSpecializationManager.addSpecialization = Utils.overwrittenFunction(g_placeableSpecializationManager.addSpecialization, function(manager, superFunc, specName, ...)
            if specName == "transferOwnershipPoint" then
                return false
            end

            return superFunc(manager, specName, ...)
        end)

        Logging.error("[%s] Failed to initialise / validate mod!", modName)
    end
end

init()
