-- Copyright 2024-2025 by Todd Hundersmarck (ThundR) 
-- All Rights Reserved

local thMain = g_thPFConfig
THNitrogenMap = {}
local THNitrogenMap_mt = THUtils.createClass(THNitrogenMap)
THNitrogenMap.DATA_KEY = thMain.modName .. ".thNitrogenMap"
local function initScript()
    local pfData = thMain.precisionFarming
    if pfData ~= nil and pfData.isFound then
        local NitrogenMap = pfData.modEnv.NitrogenMap
        THUtils.setFunctionHook(NitrogenMap, "loadFromXML", false, false, nil, THNitrogenMap.gInj_loadFromXML)
    end
end
local function getCustomData(parentEnv)
    if parentEnv ~= nil then
        return THUtils.getDataTable(parentEnv, THNitrogenMap.DATA_KEY)
    end
end
THNitrogenMap.getCustomData = getCustomData
function THNitrogenMap.new(parentEnv, customMt)
    customMt = customMt or THNitrogenMap_mt
    if THUtils.argIsValid(type(parentEnv) == THValueType.TABLE, "parentEnv", parentEnv)
        and THUtils.argIsValid(type(customMt) == THValueType.TABLE, "customMt", customMt)
    then
        local self = getCustomData(parentEnv)
        if self == nil then
            self = THUtils.createDataTable(parentEnv, THNitrogenMap.DATA_KEY, customMt)
            if self ~= nil then
                self.isModDataLoaded = false
            end
        end
        return self
    end
end
function THNitrogenMap.gInj_loadFromXML(superFunc, parentEnv, xmlFile, xmlKey, ...)
    local xmlFileType = type(xmlFile)
    if (xmlFileType == THValueType.TABLE or (xmlFileType == THValueType.NUMBER and xmlFile > 0))
        and xmlKey ~= nil and xmlKey ~= ""
    then
        THUtils.call(function()
            local self = getCustomData(parentEnv)
            if self == nil then
                self = THNitrogenMap.new(parentEnv)
            end
            if self ~= nil then
                if not self.isModDataLoaded then
                    local xmlBaseKey = xmlKey .. ".nitrogenMap"
                    local modOnLoadValues = thMain.extendedSprayTypes.modOnLoadValues
                    local usedSprayTypes, nextXMLIndex = {}, 0
                    while true do
                        local applicationRateKey = string.format("%s.applicationRates.applicationRate(%d)", xmlBaseKey, nextXMLIndex)
                        if not THUtils.hasXMLProperty(xmlFile, applicationRateKey) then
                            break
                        end
                        local sprayTypeName = THUtils.getXMLValue(xmlFile, XMLValueType.STRING, applicationRateKey, "#fillType")
                        if sprayTypeName ~= nil and sprayTypeName ~= "" then
                            usedSprayTypes[sprayTypeName:upper()] = true
                        end
                        nextXMLIndex = nextXMLIndex + 1
                    end
                    for sprayTypeId, modOnLoadData in pairs(modOnLoadValues) do
                        local applicationRateData = modOnLoadData.applicationRate
                        if not usedSprayTypes[sprayTypeId] and modOnLoadData.hasApplicationRate then
                            local applicationRateKey = string.format("%s.applicationRates.applicationRate(%d)", xmlBaseKey, nextXMLIndex)
                            THUtils.setXMLValue(xmlFile, XMLValueType.STRING, applicationRateKey, "#fillType", sprayTypeId)
                            THUtils.setXMLValue(xmlFile, XMLValueType.BOOL, applicationRateKey, "#autoAdjustToFruit", applicationRateData.adjustToFruit)
                            THUtils.setXMLValue(xmlFile, XMLValueType.FLOAT, applicationRateKey, "#regularRate", applicationRateData.regularRate)
                            local soilRates = applicationRateData.soilRates
                            if soilRates ~= nil and #soilRates > 0 then
                                for soilRateXMLIndex, soilRateData in ipairs(soilRates) do
                                    local soilRateKey = string.format("%s.soil(%d)", applicationRateKey, soilRateXMLIndex)
                                    THUtils.setXMLValue(xmlFile, XMLValueType.INT, soilRateKey, "#soilTypeIndex", soilRateData.soilTypeIndex)
                                    THUtils.setXMLValue(xmlFile, XMLValueType.FLOAT, soilRateKey, "#rate", soilRateData.soilRate)
                                end
                            end
                            nextXMLIndex = nextXMLIndex + 1
                        end
                    end
                    THUtils.clearTable(usedSprayTypes)
                    nextXMLIndex = 0
                    while true do
                        local nAmountKey = string.format("%s.fertilizerUsage.nAmount(%d)", xmlBaseKey, nextXMLIndex)
                        if not THUtils.hasXMLProperty(xmlFile, nAmountKey) then
                            break
                        end
                        local sprayTypeName = THUtils.getXMLValue(xmlFile, XMLValueType.STRING, nAmountKey, "#fillType")
                        if sprayTypeName ~= nil and sprayTypeName ~= "" then
                            usedSprayTypes[sprayTypeName:upper()] = true
                        end
                        nextXMLIndex = nextXMLIndex + 1
                    end
                    for sprayTypeId, modOnLoadData in pairs(modOnLoadValues) do
                        if not usedSprayTypes[sprayTypeId] and modOnLoadData.nAmount ~= nil then
                            local nAmountKey = string.format("%s.fertilizerUsage.nAmount(%d)", xmlBaseKey, nextXMLIndex)
                            THUtils.setXMLValue(xmlFile, XMLValueType.STRING, nAmountKey, "#fillType", sprayTypeId)
                            THUtils.setXMLValue(xmlFile, XMLValueType.FLOAT, nAmountKey, "#amount", modOnLoadData.nAmount)
                            nextXMLIndex = nextXMLIndex + 1
                        end
                    end
                    self.isModDataLoaded = true
                end
            end
        end)
    end
    return superFunc(parentEnv, xmlFile, xmlKey, ...)
end
THUtils.call(initScript)