-- Copyright 2024-2025 by Todd Hundersmarck (ThundR) 
-- All Rights Reserved

local thMain = g_thPFConfig
THStorage = {}
local function initScript()
    THUtils.setFunctionHook("Storage", "load", false, false, nil, THStorage.gInj_load)
end
function THStorage.gInj_load(superFunc, parentEnv, rootNode, xmlFile, xmlKey, ...)
    local xmlFileType = type(xmlFile)
    if (xmlFileType == THValueType.TABLE or (xmlFileType == THValueType.NUMBER and xmlFile ~= 0))
        and type(xmlKey) == THValueType.STRING
    then
        THUtils.call(function()
            local fillTypeNames = THUtils.getXMLValue(xmlFile, XMLValueType.STRING, xmlKey, "#fillTypes")
            local fillTypeCategories = THUtils.getXMLValue(xmlFile, XMLValueType.STRING, xmlKey, "#fillTypeCategories")
            if (fillTypeNames ~= nil and fillTypeNames ~= "")
                or (fillTypeCategories ~= nil and fillTypeCategories ~= "")
            then
                local newFillTypeNames, newFillTypeList = thMain:addExtendedSprayTypesToFillTypeList(fillTypeNames, fillTypeCategories, nil, true, true)
                if newFillTypeNames ~= nil then
                    if THDebugUtil.getIsEnabled(thMain.debugFlagId) then
                        THUtils.displayMsg("Storage: updated fill types: %s", newFillTypeNames)
                    end
                    THUtils.setXMLValue(xmlFile, XMLValueType.STRING, xmlKey, "#fillTypes", newFillTypeNames)
                    if fillTypeCategories ~= nil then
                        THUtils.removeXMLProperty(xmlFile, xmlKey .. "#fillTypeCategories")
                    end
                    if newFillTypeList ~= nil then
                        local capacityBaseKey = xmlKey .. ".capacity"
                        if THUtils.hasXMLProperty(xmlFile, capacityBaseKey) then
                            local capacityXMLIndex = 0
                            local capacityFillTypes, maxCapacity = {}, -1
                            while true do
                                local capacityKey = string.format("%s.capacity(%d)", capacityBaseKey, capacityXMLIndex)
                                if not THUtils.hasXMLProperty(xmlFile, capacityKey) then
                                    break
                                end
                                local fillTypeName = THUtils.getXMLValue(xmlFile, XMLValueType.STRING, capacityKey, "#fillType")
                                local capacity = THUtils.getXMLValue(xmlFile, XMLValueType.FLOAT, capacityKey, "#capacity")
                                if fillTypeName ~= nil and fillTypeName ~= ""
                                    and capacity ~= nil and capacity >= 0
                                then
                                    maxCapacity = math.max(maxCapacity, capacity)
                                    capacityFillTypes[fillTypeName:upper()] = capacity
                                end
                                capacityXMLIndex = capacityXMLIndex + 1
                            end
                            if capacityXMLIndex > 0 and maxCapacity >= 0 then
                                for fillTypeId in pairs(newFillTypeList) do
                                    if capacityFillTypes[fillTypeId] == nil then
                                        local xtSprayTypeData = thMain:getExtendedSprayTypeByFillType(fillTypeId)
                                        if xtSprayTypeData ~= nil then
                                            local capacityKey = string.format("%s.capacity(%d)", capacityXMLIndex)
                                            local newCapacity = THUtils.getNoNil(capacityFillTypes[xtSprayTypeData.baseFillTypeId], maxCapacity)
                                            if THDebugUtil.getIsEnabled(thMain.debugFlagId) then
                                                THUtils.displayMsg("Storage: setting capacity of %q to %s", xtSprayTypeData.fillTypeId, newCapacity)
                                            end
                                            THUtils.setXMLValue(xmlFile, XMLValueType.STRING, capacityKey, "#fillType", xtSprayTypeData.fillTypeId)
                                            THUtils.setXMLValue(xmlFile, XMLValueType.FLOAT, capacityKey, "#capacity", newCapacity)
                                            capacityXMLIndex = capacityXMLIndex + 1
                                        end
                                    end
                                end
                            end
                        end
                    end
                end
            end
        end)
    end
    return superFunc(parentEnv, rootNode, xmlFile, xmlKey, ...)
end
THUtils.call(initScript)