-- Copyright 2024-2025 by Todd Hundersmarck (ThundR) 
-- All Rights Reserved

local thMain = g_thPFConfig
local thMapTypeManager = thMain.thMapTypeManager
THUnloadingStation = {}
THSellingStation = {}
THUnloadTrigger = {}
local function initScript()
    THUtils.setFunctionHook("SellingStation", "load", false, false, nil, THSellingStation.gInj_load)
    THUtils.setFunctionHook("UnloadTrigger", "loadFillTypes", false, false, nil, THUnloadTrigger.gInj_loadFillTypes)
end
function THSellingStation.gInj_load(superFunc, parentEnv, rootNode, xmlFile, xmlKey, ...)
    local xmlFileType = type(xmlFile)
    if (xmlFileType == THValueType.TABLE or (xmlFileType == THValueType.NUMBER and xmlFile ~= 0))
        and type(xmlKey) == THValueType.STRING
    then
        THUtils.call(function()
            local fillTypeNames = THUtils.getXMLValue(xmlFile, XMLValueType.STRING, xmlKey, "#fillTypes")
            local fillTypeCategories = THUtils.getXMLValue(xmlFile, XMLValueType.STRING, xmlKey, "#fillTypeCategories")
            if (fillTypeNames ~= nil and fillTypeNames ~= "")
                or (fillTypeCategories ~= nil and fillTypeCategories ~= "")
            then
                local newFillTypeNames = thMain:addExtendedSprayTypesToFillTypeList(fillTypeNames, fillTypeCategories, nil, true, true)
                if newFillTypeNames ~= nil then
                    if THDebugUtil.getIsEnabled(thMain.debugFlagId) then
                        THUtils.displayMsg("SellingStation: updated fill types: %s", newFillTypeNames)
                    end
                    THUtils.setXMLValue(xmlFile, XMLValueType.STRING, xmlKey, "#fillTypes", newFillTypeNames)
                    if fillTypeCategories ~= nil then
                        THUtils.removeXMLProperty(xmlFile, xmlKey .. "#fillTypeCategories")
                    end
                end
            end
            local fillTypeXMLIndex = 0
            local stationFillTypes = {}
            local defaultPriceScale, defaultGreatDemand, defaultPriceDrop = nil, nil, nil
            while true do
                local fillTypeKey = string.format("%s.fillType(%d)", xmlKey, fillTypeXMLIndex)
                if not THUtils.hasXMLProperty(xmlFile, fillTypeKey) then
                    break
                end
                local fillTypeName = THUtils.getXMLValue(xmlFile, XMLValueType.STRING, fillTypeKey, "#name")
                local priceScale = THUtils.getXMLValue(xmlFile, XMLValueType.FLOAT, fillTypeKey, "#priceScale")
                local priceDrop = THUtils.getXMLValue(xmlFile, XMLValueType.BOOL, fillTypeKey, "#disablePriceDrop")
                local greatDemand = THUtils.getXMLValue(xmlFile, XMLValueType.BOOL, fillTypeKey, "#supportsGreatDemand")
                if fillTypeName ~= nil and fillTypeName ~= "" then
                    local thFillTypeData = thMapTypeManager:getFillType(fillTypeName)
                    local xtSprayTypeData = thMain:getExtendedSprayType(fillTypeName)
                    if thFillTypeData ~= nil and thFillTypeData ~= FillType.UNKNOWN
                        and (priceScale ~= nil or greatDemand ~= nil or priceDrop ~= nil)
                    then
                        if priceScale ~= nil then
                            if defaultPriceScale == nil or xtSprayTypeData ~= nil then
                                defaultPriceScale = priceScale
                            end
                        end
                        if priceDrop ~= nil then
                            if defaultPriceDrop == nil or xtSprayTypeData ~= nil then
                                defaultPriceDrop = priceDrop
                            end
                        end
                        if greatDemand ~= nil then
                            if defaultGreatDemand == nil or xtSprayTypeData ~= nil then
                                defaultGreatDemand = greatDemand
                            end
                        end
                        stationFillTypes[thFillTypeData.id] = {
                            priceScale = priceScale,
                            priceDrop = priceDrop,
                            greatDemand = greatDemand
                        }
                    end
                end
                fillTypeXMLIndex = fillTypeXMLIndex + 1
            end
            local _, newFillTypeList = thMain:addExtendedSprayTypesToFillTypeList(stationFillTypes, nil, nil, true, true)
            if newFillTypeList ~= nil then
                for fillTypeId, newFillTypeData in pairs(newFillTypeList) do
                    local xtSprayTypeData = thMain:getExtendedSprayTypeByFillType(fillTypeId)
                    if xtSprayTypeData ~= nil and not xtSprayTypeData.isBaseType
                        and stationFillTypes[xtSprayTypeData.fillTypeId] == nil
                    then
                        local fillTypeKey = string.format("%s.fillType(%d)", xmlKey, fillTypeXMLIndex)
                        local priceScale = THUtils.getNoNil(newFillTypeData.priceScale, defaultPriceScale)
                        local greatDemand = THUtils.getNoNil(newFillTypeData.greatDemand, defaultGreatDemand)
                        local priceDrop = THUtils.getNoNil(newFillTypeData.priceDrop, defaultPriceDrop)
                        if priceScale ~= nil or greatDemand ~= nil or priceDrop ~= nil then
                            THUtils.setXMLValue(xmlFile, XMLValueType.STRING, fillTypeKey, "#name", xtSprayTypeData.fillTypeId)
                            if priceScale ~= nil then
                                THUtils.setXMLValue(xmlFile, XMLValueType.FLOAT, fillTypeKey, "#priceScale", priceScale)
                            end
                            if greatDemand ~= nil then
                                THUtils.setXMLValue(xmlFile, XMLValueType.BOOL, fillTypeKey, "#supportsGreatDemand", greatDemand)
                            end
                            if priceDrop ~= nil then
                                THUtils.setXMLValue(xmlFile, XMLValueType.BOOL, fillTypeKey, "#disablePriceDrop", priceDrop)
                            end
                            if THDebugUtil.getIsEnabled(thMain.debugFlagId) then
                                THUtils.displayMsg("SellingStation: added fillType %q", xtSprayTypeData.fillTypeId)
                                THUtils.displayMsg("- priceScale: %s", priceScale)
                                THUtils.displayMsg("- supportsGreatDemand: %s", greatDemand)
                                THUtils.displayMsg("- disablePriceDrop: %s", priceDrop)
                            end
                            fillTypeXMLIndex = fillTypeXMLIndex + 1
                        end
                    end
                end
            end
        end)
    end
    return superFunc(parentEnv, rootNode, xmlFile, xmlKey, ...)
end
function THUnloadTrigger.gInj_loadFillTypes(superFunc, parentEnv, xmlFile, xmlKey, ...)
    local xmlFileType = type(xmlFile)
    if (xmlFileType == THValueType.TABLE or (xmlFileType == THValueType.NUMBER and xmlFile ~= 0))
        and type(xmlKey) == THValueType.STRING
    then
        THUtils.call(function()
            local fillTypeNames = THUtils.getXMLValue(xmlFile, XMLValueType.STRING, xmlKey, "#fillTypes")
            local fillTypeCategories = THUtils.getXMLValue(xmlFile, XMLValueType.STRING, xmlKey, "#fillTypeCategories")
            if (fillTypeNames ~= nil and fillTypeNames ~= "")
                or (fillTypeCategories ~= nil and fillTypeCategories ~= "")
            then
                local newFillTypeNames = thMain:addExtendedSprayTypesToFillTypeList(fillTypeNames, fillTypeCategories, nil, true, true)
                if newFillTypeNames ~= nil then
                    if THDebugUtil.getIsEnabled(thMain.debugFlagId) then
                        THUtils.displayMsg("UnloadTrigger: updated fill types: %s", newFillTypeNames)
                    end
                    THUtils.setXMLValue(xmlFile, XMLValueType.STRING, xmlKey, "#fillTypes", newFillTypeNames)
                    if fillTypeCategories ~= nil then
                        THUtils.removeXMLProperty(xmlFile, xmlKey .. "#fillTypeCategories")
                    end
                end
            end
        end)
    end
    return superFunc(parentEnv, xmlFile, xmlKey, ...)
end
THUtils.call(initScript)