floridaPlate = {}

local modDirectory = g_currentModDirectory

function floridaPlate.loadMapData(self, superFunc, xmlFile, missionInfo, baseDirectory)
    local path = modDirectory .. "xml/licensePlates.xml"
    local plateXML = loadXMLFile("FS25_floridaLicensePlates", path)

    if plateXML == nil then
        print("CUSTOM PLATE MOD: Failed to load licensePlates.xml from " .. path)
        return superFunc(self, xmlFile, missionInfo, baseDirectory)
    end

    local returnValue = superFunc(self, plateXML, missionInfo, modDirectory)

    delete(plateXML)

    return returnValue
end

LicensePlateManager.loadMapData = Utils.overwrittenFunction(LicensePlateManager.loadMapData, floridaPlate.loadMapData)
